#include "GlobalExtern.h"

void DrawFilterDetailMenu(int &Selected, vector<string> &Filter) {
	int y = MenuPosY;
	DWORD color;
	int start = 0;
	if(Selected > 7 && (Filter.size() > 15)) {
		start += (Selected  - 7);
	}
	if((Selected > ((Filter.size()-1) - 7)) && (Filter.size() > 15)) {
		start = (Filter.size() - 15);
	}
	for(int i = start; i <  start +15; i++) {
		if(i == Filter.size()) return;
		if(i ==Selected) color = 0xffff00; else color = 0xffffff; 
		WCHAR msg[1024]={0};
		std::string t = Filter[i];
		for(int r = 0; r < 1024; r++) {
			if((t.c_str())[r] == '\0') {
				msg[r] = '\0';
				break;
			}
			msg[r] = (t.c_str())[r];
		}
		FontSetColour(color);
		FontCenteredText(msg, MenuPosX, y, 640);
		y+=vSpace;
	}
}

void FilterInput() {
	ReadInput();
	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
		CancelSound();
		SaveIni();
		GUIState = MAIN_MENU;
		fadeOption = 1;
		MenuSelected= 2;
		fadeColor = 255;
		MenuBackground();
		
		return;
	}

	if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_DOWN)  {
		ClickSound();
		FilterSelected++;
		if(FilterSelected > FilterItems.size() - 1)
			FilterSelected = 0;
	}

	if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_UP)  {
		ClickSound();
		FilterSelected--;
		if(FilterSelected < 0)
			FilterSelected = FilterItems.size() - 1;
	}  

	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_A) {
		ConfirmSound();
		if(FilterSelected == 0) {
			GUIState = 13;
			return;
		}
		if(FilterSelected == 1) {
			GUIState = 14;
			return;
		}
		if(FilterSelected == 2) {
			GUIState = 15;
			return;
		}
		if(FilterSelected == 3) {
			GUIState = 16;
			return;
		}
	}
}

void DrawFilterItem(int MenuItemNumber, char* text, int x, int y) {
	unsigned int c;
	if(FilterSelected == MenuItemNumber) 
		c = 0xffff00; 
	else 
		c = 0xffffff;
	FontSetColour(c);
	FontCenteredText(ConvertCharStringToWCHAR(text), x, y, 640);
}

void DrawFilterMenu() {
	Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
	Device->SetTexture(0,TexOption);
	DrawBackground();

	if(fadeColor > 0) {
		Device->SetRenderState(D3DRS_ALPHABLENDENABLE,TRUE);
		fade = true;
		fadeColor -=fadeSpeed;
		if(fadeColor < fadeSpeed) { fadeColor = 0; }
		Device->SetTexture(0,TexMainMenu);
		DrawBackground();
		fade = false;
		Device->SetRenderState(D3DRS_ALPHABLENDENABLE,FALSE);
	}
	else {

		for(int i = 0; i < FilterItems.size(); i++) {
			DrawFilterItem(i, (char*)FilterItems[i].c_str(), MenuPosX, MenuPosY + (i * vSpace));
		}
	}
	Present();
}

void FilterMenu() {
	DrawFilterMenu();
	FilterInput();
}

void CheckFilter(int i) {
	if(DisplayMode == 0) {
		if((_tcscmp(GameDatabaseTemp[i].parent.c_str(), "NULL") == 0)) {
			////////////dprintf("Adding parent: %s\n", GameDatabaseTemp[i].name.c_str());
			GameDatabase.push_back(GameDatabaseTemp[i]);
			return;
		}
	}
	if(DisplayMode == 1) {
		if((_tcscmp(GameDatabaseTemp[i].parent.c_str(), "NULL") != 0)) {
			////////////dprintf("Adding child: %s\n", GameDatabaseTemp[i].name.c_str());
			GameDatabase.push_back(GameDatabaseTemp[i]);
			return;
		}
	}
	if(DisplayMode == 2) {
		////////////dprintf("Adding parent or child: %s\n", GameDatabaseTemp[i].name.c_str());
		GameDatabase.push_back(GameDatabaseTemp[i]);
		return;
	}
}

void CustomMenu() {
	ReadInput();
	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
		CancelSound();
		GUIState = 12;
		CustomSet = 0;
		GameSelected = 0;
		return;          
	} 
	if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_DOWN)  {
		ClickSound();
		CustomSelected++; 
		if(CustomSelected >= FilterCustom.size()) 
			CustomSelected = FilterCustom.size() - 1;
	}
	if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_UP)  {
		ClickSound();
		CustomSelected--; 
		if(CustomSelected < 0) 
			CustomSelected = 0;
	}  
	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_A) {
		if(_tcscmp("", GameDatabaseTemp[0].name.c_str()) == 0)
			return;
		ConfirmSound();
		CustomSet = 1;
		if(CustomSelected == 0) {
			GameSelected = 0;
			GameDatabase.clear();
			for(int i = 0; i < GameDatabaseTemp.size(); i++) {
				if((_tcscmp(GameDatabaseTemp[i].system.c_str(), "CPS1") == 0)) {
					CheckFilter(i);
				}
			}
			if(GameDatabase.size() == 0) {
				GameDBEntry game;
				game.name = "";
				game.displayName = "No games found";
				game.date = "";
				game.manufacturer = "";
				game.system = "";
				game.genre = "";
				game.parent = "";
				GameDatabase.push_back(game);
			}
			UpdatePreview(GameDatabase[GameSelected].name, GameDatabase[GameSelected].parent);
			GUIState = ROM_SELECT;
			fadeColor = 255;
			return;
		}
		if(CustomSelected == 1) {
			GameSelected = 0;
			GameDatabase.clear();
			for(int i = 0; i < GameDatabaseTemp.size(); i++) {
				if((_tcscmp(GameDatabaseTemp[i].system.c_str(), "CPS2") == 0)) {
					CheckFilter(i);
				}
			}
			if(GameDatabase.size() == 0) {
				GameDBEntry game;
				game.name = "";
				game.displayName = "No games found";
				game.date = "";
				game.manufacturer = "";
				game.system = "";
				game.genre = "";
				game.parent = "";
				GameDatabase.push_back(game);
			}
			UpdatePreview(GameDatabase[GameSelected].name, GameDatabase[GameSelected].parent);
			GUIState = ROM_SELECT;
			fadeColor = 255;
			return;
		}
		if(CustomSelected == 2) {
			GameSelected = 0;
			GameDatabase.clear();
			for(int i = 0; i < GameDatabaseTemp.size(); i++) {
				if((_tcscmp(GameDatabaseTemp[i].system.c_str(), "Neo Geo MVS") == 0) || 
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "Neo Geo AES") == 0)) {
					CheckFilter(i);
				}
			}
			if(GameDatabase.size() == 0) {
				GameDBEntry game;
				game.name = "";
				game.displayName = "No games found";
				game.date = "";
				game.manufacturer = "";
				game.system = "";
				game.genre = "";
				game.parent = "";
				GameDatabase.push_back(game);
			}
			UpdatePreview(GameDatabase[GameSelected].name, GameDatabase[GameSelected].parent);
			GUIState = ROM_SELECT;
			fadeColor = 255;
			return;
		}
		if(CustomSelected == 3) {
			GameSelected = 0;
			GameDatabase.clear();
			for(int i = 0; i < GameDatabaseTemp.size(); i++) {
				if((_tcscmp(GameDatabaseTemp[i].system.c_str(), "CPS1") == 0) || 
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "CPS2") == 0)) {
						CheckFilter(i);
					}
			}
			if(GameDatabase.size() == 0) {
				GameDBEntry game;
				game.name = "";
				game.displayName = "No games found";
				game.date = "";
				game.manufacturer = "";
				game.system = "";
				game.genre = "";
				game.parent = "";
				GameDatabase.push_back(game);
			}
			UpdatePreview(GameDatabase[GameSelected].name, GameDatabase[GameSelected].parent);
			GUIState = ROM_SELECT;
			fadeColor = 255;
			return;
		}
		if(CustomSelected == 4) {
			GameSelected = 0;
			GameDatabase.clear();
			for(int i = 0; i < GameDatabaseTemp.size(); i++) {
				if((_tcscmp(GameDatabaseTemp[i].system.c_str(), "CPS1") == 0) || 
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "CPS2") == 0) ||
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "Neo Geo MVS") == 0) || 
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "Neo Geo AES") == 0)) {
						CheckFilter(i);
					}
			}
			if(GameDatabase.size() == 0) {
				GameDBEntry game;
				game.name = "";
				game.displayName = "No games found";
				game.date = "";
				game.manufacturer = "";
				game.system = "";
				game.genre = "";
				game.parent = "";
				GameDatabase.push_back(game);
			}
			UpdatePreview(GameDatabase[GameSelected].name, GameDatabase[GameSelected].parent);
			GUIState = ROM_SELECT;
			fadeColor = 255;
			return;
		}
		if(CustomSelected == 5) {
			GameSelected = 0;
			GameDatabase.clear();
			for(int i = 0; i < GameDatabaseTemp.size(); i++) {
				if((_tcscmp(GameDatabaseTemp[i].system.c_str(), "PolyGameMaster") == 0) ||
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "PolyGameMaster based") == 0)) {
					CheckFilter(i);
				}
			}
			if(GameDatabase.size() == 0) {
				GameDBEntry game;
				game.name = "";
				game.displayName = "No games found";
				game.date = "";
				game.manufacturer = "";
				game.system = "";
				game.genre = "";
				game.parent = "";
				GameDatabase.push_back(game);
			}
			UpdatePreview(GameDatabase[GameSelected].name, GameDatabase[GameSelected].parent);
			GUIState = ROM_SELECT;
			fadeColor = 255;
			return;
		}
		if(CustomSelected == 6) {
			GameSelected = 0;
			GameDatabase.clear();
			for(int i = 0; i < GameDatabaseTemp.size(); i++) {
				if((_tcscmp(GameDatabaseTemp[i].system.c_str(), "Cave") == 0)) {
					CheckFilter(i);
				}
			}
			if(GameDatabase.size() == 0) {
				GameDBEntry game;
				game.name = "";
				game.displayName = "No games found";
				game.date = "";
				game.manufacturer = "";
				game.system = "";
				game.genre = "";
				game.parent = "";
				GameDatabase.push_back(game);
			}
			UpdatePreview(GameDatabase[GameSelected].name, GameDatabase[GameSelected].parent);
			GUIState = ROM_SELECT;
			fadeColor = 255;
			return;
		}
		if(CustomSelected == 7) {
			GameSelected = 0;
			GameDatabase.clear();
			for(int i = 0; i < GameDatabaseTemp.size(); i++) {
				if((_tcscmp(GameDatabaseTemp[i].system.c_str(), "Cave") == 0) ||
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "PolyGameMaster") == 0) ||
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "PolyGameMaster based") == 0)) {
					CheckFilter(i);
				}
			}
			if(GameDatabase.size() == 0) {
				GameDBEntry game;
				game.name = "";
				game.displayName = "No games found";
				game.date = "";
				game.manufacturer = "";
				game.system = "";
				game.genre = "";
				game.parent = "";
				GameDatabase.push_back(game);
			}
			UpdatePreview(GameDatabase[GameSelected].name, GameDatabase[GameSelected].parent);
			GUIState = ROM_SELECT;
			fadeColor = 255;
			return;
		}
		if(CustomSelected == 8) {
			GameSelected = 0;
			GameDatabase.clear();
			for(int i = 0; i < GameDatabaseTemp.size(); i++) {
					if(((_tcscmp(GameDatabaseTemp[i].system.c_str(), "Psikyo 68EC020") == 0) ||
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "PS3-V1") == 0) ||
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "PS5") == 0) ||
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "PS4") == 0) ||
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "PS5V2") == 0))) {
					CheckFilter(i);
					}
			}
			if(GameDatabase.size() == 0) {
				GameDBEntry game;
				game.name = "";
				game.displayName = "No games found";
				game.date = "";
				game.manufacturer = "";
				game.system = "";
				game.genre = "";
				game.parent = "";
				GameDatabase.push_back(game);
			}
			UpdatePreview(GameDatabase[GameSelected].name, GameDatabase[GameSelected].parent);
			GUIState = ROM_SELECT;
			fadeColor = 255;
			return;
		}
		if(CustomSelected == 9) {
			GameSelected = 0;
			GameDatabase.clear();
			for(int i = 0; i < GameDatabaseTemp.size(); i++) {
					if(((_tcscmp(GameDatabaseTemp[i].system.c_str(), "Psikyo 68EC020") == 0) ||
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "PS3-V1") == 0) ||
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "PS5") == 0) ||
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "PS4") == 0) ||
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "Cave") == 0) ||
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "PS5V2") == 0))) {
						CheckFilter(i);
					}
			}
			if(GameDatabase.size() == 0) {
				GameDBEntry game;
				game.name = "";
				game.displayName = "No games found";
				game.date = "";
				game.manufacturer = "";
				game.system = "";
				game.genre = "";
				game.parent = "";
				GameDatabase.push_back(game);
			}
			UpdatePreview(GameDatabase[GameSelected].name, GameDatabase[GameSelected].parent);
			GUIState = ROM_SELECT;
			fadeColor = 255;
			return;
		}
		if(CustomSelected == 10) {
			GameSelected = 0;
			GameDatabase.clear();
			for(int i = 0; i < GameDatabaseTemp.size(); i++) {
				 if((_tcscmp(GameDatabaseTemp[i].system.c_str(), "CPS1") != 0) && 
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "CPS2") != 0) &&
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "Cave") != 0) &&
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "Megadrive") != 0) &&
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "Neo Geo MVS") != 0) &&
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "Neo Geo AES") != 0) &&					
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "Psikyo 68EC020") != 0) &&
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "PS3-V1") != 0) &&
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "PS5") != 0) &&
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "Konami") != 0) &&
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "Kn") != 0) &&
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "Sega") != 0) &&
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "PolyGameMaster") != 0) &&
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "PS5V2") != 0) &&
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "PolyGameMaster based") != 0)&&
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "Taito Misc") != 0) &&
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "Taito-F2") != 0) &&
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "Taito-X") != 0) &&
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "Taito-Z") != 0)&&
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "To") != 0) &&
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "Toaplan BCU-2 / FCU-2 based") != 0) &&
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "Toaplan GP9001 based") != 0) &&
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "Data East") != 0) &&
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "De") != 0) &&
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "Dual Toaplan GP9001 based") != 0)) {
						CheckFilter(i);
					}
			}
			if(GameDatabase.size() == 0) {
				GameDBEntry game;
				game.name = "";
				game.displayName = "No games found";
				game.date = "";
				game.manufacturer = "";
				game.system = "";
				game.genre = "";
				game.parent = "";
				GameDatabase.push_back(game);
			}
			UpdatePreview(GameDatabase[GameSelected].name, GameDatabase[GameSelected].parent);
			GUIState = ROM_SELECT;
			fadeColor = 255;
			return;
		}
		if(CustomSelected == 11) {
			GameSelected = 0;
			GameDatabase.clear();
			for(int i = 0; i < GameDatabaseTemp.size(); i++) {
				if((_tcscmp(GameDatabaseTemp[i].manufacturer.c_str(), "Konami") == 0) &&
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "Kn") != 0) &&
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "Megadrive") != 0)) {
						CheckFilter(i);
					}
			}
			if(GameDatabase.size() == 0) {
				GameDBEntry game;
				game.name = "";
				game.displayName = "No games found";
				game.date = "";
				game.manufacturer = "";
				game.system = "";
				game.genre = "";
				game.parent = "";
				GameDatabase.push_back(game);
			}
			UpdatePreview(GameDatabase[GameSelected].name, GameDatabase[GameSelected].parent);
			GUIState = ROM_SELECT;
			fadeColor = 255;
			return;
		}
		if(CustomSelected == 12) {
			GameSelected = 0;
			GameDatabase.clear();
			for(int i = 0; i < GameDatabaseTemp.size(); i++) {
				if((_tcscmp(GameDatabaseTemp[i].manufacturer.c_str(), "Sega") == 0) &&
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "De") != 0) &&
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "Data East") != 0)) {
						CheckFilter(i);
					}
			}
			if(GameDatabase.size() == 0) {
				GameDBEntry game;
				game.name = "";
				game.displayName = "No games found";
				game.date = "";
				game.manufacturer = "";
				game.system = "";
				game.genre = "";
				game.parent = "";
				GameDatabase.push_back(game);
			}
			UpdatePreview(GameDatabase[GameSelected].name, GameDatabase[GameSelected].parent);
			GUIState = ROM_SELECT;
			fadeColor = 255;
			return;
		}
		if(CustomSelected == 13) {
			GameSelected = 0;
			GameDatabase.clear();
			for(int i = 0; i < GameDatabaseTemp.size(); i++) {
				if((_tcscmp(GameDatabaseTemp[i].system.c_str(), "Taito Misc") == 0) ||
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "Taito-F2") == 0) ||
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "Taito-X") == 0) ||
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "To") == 0) ||
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "Taito-Z") == 0)) {
						CheckFilter(i);
					}
			}
			if(GameDatabase.size() == 0) {
				GameDBEntry game;
				game.name = "";
				game.displayName = "No games found";
				game.date = "";
				game.manufacturer = "";
				game.system = "";
				game.genre = "";
				game.parent = "";
				GameDatabase.push_back(game);
			}
			UpdatePreview(GameDatabase[GameSelected].name, GameDatabase[GameSelected].parent);
			GUIState = ROM_SELECT;
			fadeColor = 255;
			return;
		}
		if(CustomSelected == 14) {
			GameSelected = 0;
			GameDatabase.clear();
			for(int i = 0; i < GameDatabaseTemp.size(); i++) {
				if((_tcscmp(GameDatabaseTemp[i].system.c_str(), "Toaplan BCU-2 / FCU-2 based") == 0) ||
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "Toaplan GP9001 based") == 0) ||
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "Dual Toaplan GP9001 based") == 0)) {
						CheckFilter(i);
					}
			}
			if(GameDatabase.size() == 0) {
				GameDBEntry game;
				game.name = "";
				game.displayName = "No games found";
				game.date = "";
				game.manufacturer = "";
				game.system = "";
				game.genre = "";
				game.parent = "";			
				GameDatabase.push_back(game);
			}
			UpdatePreview(GameDatabase[GameSelected].name, GameDatabase[GameSelected].parent);
			GUIState = ROM_SELECT;
			fadeColor = 255;
			return;
		}
		if(CustomSelected == 15) {
			GameSelected = 0;
			GameDatabase.clear();
			for(int i = 0; i < GameDatabaseTemp.size(); i++) {
                if((_tcscmp(GameDatabaseTemp[i].system.c_str(), "Data East") == 0) ||
				   (_tcscmp(GameDatabaseTemp[i].system.c_str(), "De") == 0)) {
						CheckFilter(i);
					}
			}
			if(GameDatabase.size() == 0) {
				GameDBEntry game;
				game.name = "";
				game.displayName = "No games found";
				game.date = "";
				game.manufacturer = "";
				game.system = "";
				game.genre = "";
				game.parent = "";				
				GameDatabase.push_back(game);
			}
			UpdatePreview(GameDatabase[GameSelected].name, GameDatabase[GameSelected].parent);
			GUIState = ROM_SELECT;
			fadeColor = 255;
			return;
		}						
	}
	if( g_Gamepads[DefaultController].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER]) {
		if(analogSpeed >= 1) { 
			analogSpeed = 0; 
		} 
		if(rightAnalog == 255)
			analogSpeed = scrollSpeed;
		else
			analogSpeed += ((float)rightAnalog/255.0f);
		CustomSelected+=((int)analogSpeed); 
		if(CustomSelected >= FilterCustom.size()) 
			CustomSelected = FilterCustom.size() - 1;
	}
	if( g_Gamepads[DefaultController].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER]) {
		if(analogSpeed >= 1)  { 
			analogSpeed = 0;
		}
		if(leftAnalog == 255)
			analogSpeed = scrollSpeed;
		else
			analogSpeed += ((float)leftAnalog/255.0f);
		CustomSelected-=((int)analogSpeed); if(CustomSelected < 0) CustomSelected = 0;
	}
	Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
	Device->SetTexture(0,TexOption);
	DrawBackground();
	if(fadeColor > 0) {
		Device->SetRenderState(D3DRS_ALPHABLENDENABLE,TRUE);
		fade = true;
		fadeColor -=fadeSpeed;
		if(fadeColor < fadeSpeed) { fadeColor = 0; }
		Device->SetTexture(0,TexROMBrowser);
		DrawBackground();
		fade = false;
		Device->SetRenderState(D3DRS_ALPHABLENDENABLE,FALSE);
	}
	else {  
		DrawFilterDetailMenu(CustomSelected, FilterCustom);
	}
	Present();	
}

void CompanyMenu() {
	ReadInput();
	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
		CancelSound();
		GUIState = 12;
		CompanySet = 0;
		GameSelected = 0;
		return;          
	} 
	if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_DOWN)  {
		ClickSound();
		CompanySelected++; 
		if(CompanySelected >= FilterCompany.size()) 
			CompanySelected = FilterCompany.size() - 1;
	}
	if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_UP)  {
		ClickSound();
		CompanySelected--; 
		if(CompanySelected < 0) 
			CompanySelected = 0;
	}  
	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_A) {
		if(_tcscmp("", GameDatabaseTemp[0].name.c_str()) == 0)
			return;
		ConfirmSound();
		CompanySet = 1;
		GameSelected = 0;
		GameDatabase.clear();
		for(int i = 0; i < GameDatabaseTemp.size(); i++) {
			if((_tcscmp(GameDatabaseTemp[i].manufacturer.c_str(),  FilterCompany[CompanySelected].c_str()) == 0)) {
				CheckFilter(i);
			}
		}
		if(GameDatabase.size() == 0) {
			GameDBEntry game;
			game.name = "";
			game.displayName = "No games found";
			game.date = "";
			game.manufacturer = "";
			game.system = "";
			game.genre = "";
			game.parent = "";
			GameDatabase.push_back(game);
		}
		UpdatePreview(GameDatabase[GameSelected].name, GameDatabase[GameSelected].parent);
		GUIState = ROM_SELECT;
		fadeColor = 255;
		return;
	}

	if( g_Gamepads[DefaultController].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER]) {
		if(analogSpeed >= 1) { 
			analogSpeed = 0; 
		} 
		if(rightAnalog == 255)
			analogSpeed = scrollSpeed;
		else
			analogSpeed += ((float)rightAnalog/255.0f);
		CompanySelected+=((int)analogSpeed); 
		if(CompanySelected >= FilterCompany.size()) 
			CompanySelected = FilterCompany.size() - 1;
	}
	if( g_Gamepads[DefaultController].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER]) {
		if(analogSpeed >= 1)  { 
			analogSpeed = 0;
		}
		if(leftAnalog == 255)
			analogSpeed = scrollSpeed;
		else
			analogSpeed += ((float)leftAnalog/255.0f);
		CompanySelected-=((int)analogSpeed); if(CompanySelected < 0) CompanySelected = 0;
	}
	Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
	Device->SetTexture(0,TexOption);
	DrawBackground();
	if(fadeColor > 0) {
		Device->SetRenderState(D3DRS_ALPHABLENDENABLE,TRUE);
		fade = true;
		fadeColor -=fadeSpeed;
		if(fadeColor < fadeSpeed) { fadeColor = 0; }
		Device->SetTexture(0,TexROMBrowser);
		DrawBackground();
		fade = false;
		Device->SetRenderState(D3DRS_ALPHABLENDENABLE,FALSE);
	}
	else {  
		DrawFilterDetailMenu(CompanySelected, FilterCompany);
	}
	Present();
}

void YearMenu() {
	ReadInput();
	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
		CancelSound();
		GUIState = 12;
		YearSet = 0;
		GameSelected = 0;
		return;          
	} 
	if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_DOWN)  {
		ClickSound();
		YearSelected++; 
		if(YearSelected >= FilterYear.size()) 
			YearSelected = FilterYear.size() - 1;
	}
	if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_UP)  { 
		ClickSound();
		YearSelected--; 
		if(YearSelected < 0) 
			YearSelected = 0;
	}  
	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_A) {
		if(_tcscmp("", GameDatabaseTemp[0].name.c_str()) == 0)
			return;
		ConfirmSound();
		YearSet = 1;
		GameSelected = 0;
		GameDatabase.clear();
		for(int i = 0; i < GameDatabaseTemp.size(); i++) {
			if((_tcscmp(GameDatabaseTemp[i].date.c_str(),  FilterYear[YearSelected].c_str()) == 0)) {
				CheckFilter(i);
			}
		}
		if(GameDatabase.size() == 0) {
			GameDBEntry game;
			game.name = "";
			game.displayName = "No games found";
			game.date = "";
			game.manufacturer = "";
			game.system = "";
			game.genre = "";
			game.parent = "";
			GameDatabase.push_back(game);
		}
		UpdatePreview(GameDatabase[GameSelected].name, GameDatabase[GameSelected].parent);
		GUIState = ROM_SELECT;
		fadeColor = 255;
		return;
	}
	if( g_Gamepads[DefaultController].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER]) {
		if(analogSpeed >= 1) { 
			analogSpeed = 0; 
		} 
		if(rightAnalog == 255)
			analogSpeed = scrollSpeed;
		else
			analogSpeed += ((float)rightAnalog/255.0f);
		YearSelected+=((int)analogSpeed); 
		if(YearSelected >= FilterYear.size()) 
			YearSelected = FilterYear.size() - 1;
	}
	if( g_Gamepads[DefaultController].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER]) {
		if(analogSpeed >= 1)  { 
			analogSpeed = 0;
		}
		if(leftAnalog == 255)
			analogSpeed = scrollSpeed;
		else
			analogSpeed += ((float)leftAnalog/255.0f);
		YearSelected-=((int)analogSpeed); if(YearSelected < 0) YearSelected = 0;
	}

	Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
	Device->SetTexture(0,TexOption);
	DrawBackground();
	if(fadeColor > 0) {
		Device->SetRenderState(D3DRS_ALPHABLENDENABLE,TRUE);
		fade = true;
		fadeColor -=fadeSpeed;
		if(fadeColor < fadeSpeed) { fadeColor = 0; }
		Device->SetTexture(0,TexROMBrowser);
		DrawBackground();
		fade = false;
		Device->SetRenderState(D3DRS_ALPHABLENDENABLE,FALSE);
	}
	else {  
		DrawFilterDetailMenu(YearSelected, FilterYear);
	}
	Present();
}

void GenreMenu() {
	ReadInput();
	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
		CancelSound();
		GUIState = 12;
		GenreSet = 0;
		GameSelected = 0;
		return;          
	} 
	if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_DOWN)  {
		ClickSound();
		GenreSelected++; 
		if(GenreSelected >= FilterGenre.size()) 
			GenreSelected = FilterGenre.size() - 1;
	}
	if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_UP)  {
		ClickSound();
		GenreSelected--; 
		if(GenreSelected < 0) 
			GenreSelected = 0;
	}  
	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_A) {
		if(_tcscmp("", GameDatabaseTemp[0].name.c_str()) == 0)
			return;
		ConfirmSound();
		GenreSet = 1;
		GameSelected = 0;
		GameDatabase.clear();
		for(int i = 0; i < GameDatabaseTemp.size(); i++) {
			if((_tcscmp(GameDatabaseTemp[i].genre.c_str(),  FilterGenre[GenreSelected].c_str()) == 0)) {
				CheckFilter(i);
			}
		}
		if(GameDatabase.size() == 0) {
			GameDBEntry game;
			game.name = "";
			game.displayName = "No games found";
			game.date = "";
			game.manufacturer = "";
			game.system = "";
			game.genre = "";
			game.parent = "";
			GameDatabase.push_back(game);
		}
		UpdatePreview(GameDatabase[GameSelected].name, GameDatabase[GameSelected].parent);
		GUIState = ROM_SELECT;
		fadeColor = 255;
		return;
	}
	if( g_Gamepads[DefaultController].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER]) {
		if(analogSpeed >= 1) { 
			analogSpeed = 0; 
		} 
		if(rightAnalog == 255)
			analogSpeed = scrollSpeed;
		else
			analogSpeed += ((float)rightAnalog/255.0f);
		GenreSelected+=((int)analogSpeed); 
		if(GenreSelected >= FilterGenre.size()) 
			GenreSelected = FilterGenre.size() - 1;
	}
	if( g_Gamepads[DefaultController].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER]) {
		if(analogSpeed >= 1)  { 
			analogSpeed = 0;
		}
		if(leftAnalog == 255)
			analogSpeed = scrollSpeed;
		else
			analogSpeed += ((float)leftAnalog/255.0f);
		GenreSelected-=((int)analogSpeed); if(GenreSelected < 0) GenreSelected = 0;
	}

	Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
	Device->SetTexture(0,TexOption);
	DrawBackground();
	if(fadeColor > 0) {
		Device->SetRenderState(D3DRS_ALPHABLENDENABLE,TRUE);
		fade = true;
		fadeColor -=fadeSpeed;
		if(fadeColor < fadeSpeed) { fadeColor = 0; }
		Device->SetTexture(0,TexROMBrowser);
		DrawBackground();
		fade = false;
		Device->SetRenderState(D3DRS_ALPHABLENDENABLE,FALSE);
	}
	else {  
		DrawFilterDetailMenu(GenreSelected, FilterGenre);
	}
	Present();
}

